#pragma once
#include <windows.h>

struct VDPPluginInfos
{
	// pointer to function requesting a Sprite Draw End interrupt (master SH2)
	void   (__cdecl * pfSDEInterrupt)(void);
	// function to write text in the emu's client area
	// color:0x00RRGGBB
	// please do not use "/n" character, use instead multiple calls to function to write multiple lines
	void   (__cdecl * pfWriteText)(char *text,unsigned long color);
	// handle to the application's handle
	HINSTANCE hInstance;
	// Plugin version
	// you must return the plugin interface version you implement
	// format: 0xnm for version n.m
	unsigned char version;
};

#if defined(__cplusplus)
extern "C" {
#endif

//////////////////////////////////////
// VDP plugin interface version 1.0 //
//////////////////////////////////////

// called to init the plugin, return true if success
__declspec(dllexport) bool _cdecl InitVDPPlugin(VDPPluginInfos * infos);
// called to deinit the plugin
__declspec(dllexport) void _cdecl DeInitPlugin(void);
// for the about dialog box of the plugin
__declspec(dllexport) void _cdecl DisplayPluginInfo(void);
// must display a dialog box to configure the plugin
__declspec(dllexport) void _cdecl SetupPlugin(void);

// reset
__declspec(dllexport) void _cdecl Reset(void);
//////////////////////////
// VDP1
// write to VDP1 registers
__declspec(dllexport) void _fastcall WriteWordVDP1Regs(unsigned long address,unsigned short data);
// read from VDP1 registers
__declspec(dllexport) unsigned short _fastcall ReadWordVDP1Regs(unsigned long address);
// write to back frame buffer
__declspec(dllexport) void _fastcall WriteByteVDP1FrameBuffer(unsigned long address,unsigned char data);
__declspec(dllexport) void _fastcall WriteWordVDP1FrameBuffer(unsigned long address,unsigned short data);
// read from back frame buffer
__declspec(dllexport) unsigned char _fastcall ReadByteVDP1FrameBuffer(unsigned long address);
__declspec(dllexport) unsigned short _fastcall ReadWordVDP1FrameBuffer(unsigned long address);
// write to VDP1 VRAM
__declspec(dllexport) void _fastcall WriteByteVDP1VRAM(unsigned long address,unsigned char data);
__declspec(dllexport) void _fastcall WriteWordVDP1VRAM(unsigned long address,unsigned short data);
__declspec(dllexport) void _fastcall WriteLongVDP1VRAM(unsigned long address,unsigned long data);
// read from VDP1 VRAM
__declspec(dllexport) unsigned char _fastcall ReadByteVDP1VRAM(unsigned long address);
__declspec(dllexport) unsigned short _fastcall ReadWordVDP1VRAM(unsigned long address);
__declspec(dllexport) unsigned long _fastcall ReadLongVDP1VRAM(unsigned long address);
//////////////////////////
// VDP2
// write to VDP2 registers
__declspec(dllexport) void _fastcall WriteWordVDP2Regs(unsigned long address,unsigned short data);
__declspec(dllexport) void _fastcall WriteLongVDP2Regs(unsigned long address,unsigned long data);
// read from VDP2 registers
__declspec(dllexport) unsigned short _fastcall ReadWordVDP2Regs(unsigned long address);
__declspec(dllexport) unsigned long _fastcall ReadLongVDP2Regs(unsigned long address);
// write to VDP2 VRAM
__declspec(dllexport) void _fastcall WriteByteVDP2VRAM(unsigned long address,unsigned char data);
__declspec(dllexport) void _fastcall WriteWordVDP2VRAM(unsigned long address,unsigned short data);
__declspec(dllexport) void _fastcall WriteLongVDP2VRAM(unsigned long address,unsigned long data);
// read from VDP2 VRAM
__declspec(dllexport) unsigned char _fastcall ReadByteVDP2VRAM(unsigned long address);
__declspec(dllexport) unsigned short _fastcall ReadWordVDP2VRAM(unsigned long address);
__declspec(dllexport) unsigned long _fastcall ReadLongVDP2VRAM(unsigned long address);
// write to color RAM
__declspec(dllexport) void _fastcall WriteWordVDP2CRAM(unsigned long address,unsigned short data);
__declspec(dllexport) void _fastcall WriteLongVDP2CRAM(unsigned long address,unsigned long data);
// read from color RAM
__declspec(dllexport) unsigned short _fastcall ReadWordVDP2CRAM(unsigned long address);
__declspec(dllexport) unsigned long _fastcall ReadLongVDP2CRAM(unsigned long address);
// various screen related events
__declspec(dllexport) void _cdecl VDPOnVblankIn(void);
__declspec(dllexport) void _cdecl VDPOnVblankOut(void);
__declspec(dllexport) void _cdecl VDPOnHblankIn(void);
__declspec(dllexport) void _cdecl VDPOnHblankOut(void);

#if defined(__cplusplus)
}
#endif